﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace OdtwarzaczMultimedialny
{
    public partial class Form1 : Form
    {
        public static AxWMPLib.AxWindowsMediaPlayer player;                      
        private static Form1 Key;
        private Lista listaUI;

        public Form1()
        {
            InitializeComponent();                      
        }

        private void button1_Click(object sender, EventArgs e)
        {            
            string odtwarzaj = "Odtwarzaj",
                pauza = "Pauza";

            if (axWindowsMediaPlayer1.playState != WMPLib.WMPPlayState.wmppsPlaying)
            {
                button1.Text = pauza;        
                axWindowsMediaPlayer1.Ctlcontrols.play();                                
                if (!backgroundWorker1.IsBusy)
                {
                    // Uruchomienie wątku roboczego
                    backgroundWorker1.RunWorkerAsync();
                }
            }
            else
            {
                button1.Text = odtwarzaj;
                axWindowsMediaPlayer1.Ctlcontrols.pause();                
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (axWindowsMediaPlayer1.playState == WMPLib.WMPPlayState.wmppsPlaying)
            {
                axWindowsMediaPlayer1.Ctlcontrols.stop();
                button1.Text = "Odtwarzaj";
            }
        }

        private void ustawPozycje(int pozycja)
        {
            progressBar1.Value = pozycja;
        }

        private delegate void ustawPozycjeDelegate(int pozycja);

        /*
        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {          
            while (axWindowsMediaPlayer1.Ctlcontrols.currentPosition 
                <= axWindowsMediaPlayer1.Ctlcontrols.currentItem.duration)
            {
                int pozycja = (int) Math.Floor(
                    100 * axWindowsMediaPlayer1.Ctlcontrols.currentPosition 
                    / axWindowsMediaPlayer1.currentMedia.duration);

                if (progressBar1.InvokeRequired)
                    progressBar1.BeginInvoke(new ustawPozycjeDelegate(ustawPozycje), pozycja);
   
                System.Threading.Thread.Sleep(500);
            }            
        }
        */

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            if (axWindowsMediaPlayer1 != null)
            {
                while (axWindowsMediaPlayer1.Ctlcontrols.currentPosition
                    <= axWindowsMediaPlayer1.Ctlcontrols.currentItem.duration)
                {
                    int pozycja = (int)Math.Floor(
                        100 * axWindowsMediaPlayer1.Ctlcontrols.currentPosition
                        / axWindowsMediaPlayer1.currentMedia.duration);

                    if (progressBar1.InvokeRequired)
                        progressBar1.BeginInvoke(new ustawPozycjeDelegate(ustawPozycje), pozycja);

                    System.Threading.Thread.Sleep(500);
                }
            }
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            // Wyłączenie odtwarzania
            button2_Click(this, e);
            axWindowsMediaPlayer1.Dispose();
            base.OnClosing(e);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Text = System.IO.Path.GetFileName(openFileDialog1.FileName);
                WMPLib.IWMPMedia3 media = 
                    (WMPLib.IWMPMedia3)axWindowsMediaPlayer1.mediaCollection.
                    add(openFileDialog1.FileName);
                axWindowsMediaPlayer1.currentMedia = media;
                if (axWindowsMediaPlayer1.playState == WMPLib.WMPPlayState.wmppsPlaying)
                    button1.Text = "Odtwarzaj";
            }
            else
                textBox1.Text = "Nie wybrano pliku";
        }

        private void trackBar1_Scroll(object sender, EventArgs e)
        {
            axWindowsMediaPlayer1.settings.volume = trackBar1.Value;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            trackBar1.Value = axWindowsMediaPlayer1.settings.volume;
            player = axWindowsMediaPlayer1;
            Key = this;            
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            axWindowsMediaPlayer1.settings.mute = checkBox1.Checked;
        }

        private void progressBar1_MouseClick(object sender, MouseEventArgs e)
        {
            if(e.Button == MouseButtons.Left)
                if (axWindowsMediaPlayer1.playState == WMPLib.WMPPlayState.wmppsPlaying)
                {
                    int pos = 100*e.X / progressBar1.Width;
                    axWindowsMediaPlayer1.Ctlcontrols.currentPosition = 
                        pos * axWindowsMediaPlayer1.currentMedia.duration / 100;                    
                }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if (axWindowsMediaPlayer1.playState == WMPLib.WMPPlayState.wmppsPlaying)
                axWindowsMediaPlayer1.fullScreen = true;
        }

        private void button5_Click(object sender, EventArgs e)
        {
            if(listaUI == null || listaUI.IsDisposed)
                listaUI = new Lista();
            listaUI.Visible = listaUI.Visible ? false : true;         
        }

        public static void odtwarzaj()
        {
            Key.button1_Click(null, null);            
        }

        public static void zatrzymajOdtwarzanie()
        {
            Key.button2_Click(null, null);
        }

    }
}
